/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.MouseTracker;
import CH.ifa.draw.util.ColorMap;
import DE.siemens.ad.pdraw.figures.DashedRectangleFigure;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class SelectAreaTracker
extends MouseTracker {
    private Rectangle fSelectGroup;
    protected RectangleFigure fRubberBand = new DashedRectangleFigure();

    public SelectAreaTracker() {
        this.fRubberBand.setAttribute("FillColor", ColorMap.color("color.none"));
    }

    private void drawXORRect(DrawingView view, Rectangle r) {
        Graphics g = view.getGraphics();
        g.setXORMode(view.getBackground());
        g.setColor(Color.black);
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    private void eraseRubberBand(DrawingView view) {
        this.drawXORRect(view, this.fSelectGroup);
    }

    public void mouseDown(MouseEvent e, int x, int y, DrawingView view) {
        super.mouseDown(e, e.getX(), e.getY(), view);
        ((LogoDrawing)view.drawing()).addWithoutModified(this.fRubberBand);
        this.rubberBand(view, this.fAnchor.x, this.fAnchor.y, this.fAnchor.x, this.fAnchor.y);
    }

    public void mouseDrag(MouseEvent e, int x, int y, DrawingView view) {
        super.mouseDrag(e, x, y, view);
        this.rubberBand(view, this.fAnchor.x, this.fAnchor.y, x, y);
    }

    public void mouseUp(MouseEvent e, int x, int y, DrawingView view) {
        super.mouseUp(e, x, y, view);
        ((LogoDrawing)view.drawing()).removeFromDrawingWithoutModified(this.fRubberBand);
        this.selectGroup(view, e.isControlDown());
    }

    private void rubberBand(DrawingView view, int x1, int y1, int x2, int y2) {
        this.fSelectGroup = new Rectangle(new Point(x1, y1));
        this.fSelectGroup.add(new Point(x2, y2));
        this.fRubberBand.displayBox(new Point(x1, y1), new Point(x2, y2));
        view.drawing().forceUpdate();
    }

    private void selectGroup(DrawingView view, boolean toggle) {
        FigureEnumeration k = view.drawing().figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            Rectangle r2 = figure.selectionBox();
            if (!this.fSelectGroup.contains(r2.x, r2.y) || !this.fSelectGroup.contains(r2.x + r2.width, r2.y + r2.height)) continue;
            if (toggle) {
                view.toggleSelection(figure);
                continue;
            }
            view.addToSelection(figure);
        }
    }

    public void keyDown(KeyEvent evt, int key, DrawingView view) {
    }
}

